/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.common.recipe;

import com.alcatrazescapee.alcatrazcore.inventory.recipe.IRecipeCore;
import com.alcatrazescapee.alcatrazcore.inventory.recipe.IRecipeManager;
import com.alcatrazescapee.alcatrazcore.inventory.recipe.RecipeManager;
import com.alcatrazescapee.notreepunching.ModConfig;
import com.alcatrazescapee.notreepunching.common.blocks.BlockCobble;
import com.alcatrazescapee.notreepunching.common.blocks.BlockPottery;
import com.alcatrazescapee.notreepunching.common.items.ModItems;
import com.alcatrazescapee.notreepunching.common.recipe.FirePitRecipe;
import com.alcatrazescapee.notreepunching.common.recipe.IRecipeAction;
import com.alcatrazescapee.notreepunching.common.recipe.KnifeRecipe;
import com.alcatrazescapee.notreepunching.util.Util;
import com.alcatrazescapee.notreepunching.util.types.Metal;
import com.alcatrazescapee.notreepunching.util.types.Pottery;
import com.alcatrazescapee.notreepunching.util.types.Stone;
import com.alcatrazescapee.notreepunching.util.types.ToolType;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;

public final class ModRecipes {
    public static final IRecipeManager<FirePitRecipe> FIRE_PIT = new RecipeManager();
    public static final IRecipeManager<KnifeRecipe> KNIFE = new RecipeManager();
    private static final List<IRecipeAction> actions = new LinkedList<IRecipeAction>();

    public static void init() {
        for (Pottery type : Pottery.values()) {
            if (type == Pottery.WORKED) continue;
            BlockPottery block = BlockPottery.get(type);
            GameRegistry.addSmelting((Block)block, (ItemStack)block.getFiredType(), (float)0.1f);
            FIRE_PIT.add((IRecipeCore)new FirePitRecipe(block.getFiredType(), new ItemStack((Block)block)));
        }
        Map map = FurnaceRecipes.func_77602_a().func_77599_b();
        for (Map.Entry m : map.entrySet()) {
            if (!(((ItemStack)m.getValue()).func_77973_b() instanceof ItemFood)) continue;
            FIRE_PIT.add((IRecipeCore)new FirePitRecipe(((ItemStack)m.getValue()).func_77946_l(), ((ItemStack)m.getKey()).func_77946_l()));
        }
        for (Stone stone : Stone.values()) {
            if (!stone.isEnabled() || !stone.hasCobblestone()) continue;
            GameRegistry.addSmelting((Block)BlockCobble.get(stone), (ItemStack)stone.getStoneStack(), (float)0.1f);
        }
        GameRegistry.addSmelting((Item)ModItems.GRASS_STRING, (ItemStack)new ItemStack(Items.field_151007_F), (float)0.1f);
        GameRegistry.addSmelting((Item)ModItems.CLAY_BRICK, (ItemStack)new ItemStack(Items.field_151118_aC), (float)0.1f);
        FIRE_PIT.add((IRecipeCore)new FirePitRecipe(new ItemStack(Items.field_151118_aC), "brickClay", 1));
        KNIFE.add((IRecipeCore)new KnifeRecipe("rock", 1, new ItemStack(ModItems.FLINT_SHARD)));
        KNIFE.add((IRecipeCore)new KnifeRecipe(new ItemStack(Items.field_151145_ak), new ItemStack(ModItems.FLINT_SHARD, 2)));
        KNIFE.add((IRecipeCore)new KnifeRecipe(new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE), new ItemStack(Items.field_151007_F, 4)));
        KNIFE.add((IRecipeCore)new KnifeRecipe(new ItemStack(Blocks.field_150321_G), new ItemStack(Items.field_151007_F, 8)));
        KNIFE.add((IRecipeCore)new KnifeRecipe(new ItemStack(Items.field_151120_aE), new ItemStack(ModItems.GRASS_FIBER, 2)));
        KNIFE.add((IRecipeCore)new KnifeRecipe(new ItemStack(Items.field_151015_O), new ItemStack(ModItems.GRASS_FIBER, 1), new ItemStack(Items.field_151014_N)));
        KNIFE.add((IRecipeCore)new KnifeRecipe(new ItemStack((Item)Items.field_151021_T), new ItemStack(Items.field_151116_aA, 2)));
        KNIFE.add((IRecipeCore)new KnifeRecipe(new ItemStack((Item)Items.field_151027_R), new ItemStack(Items.field_151116_aA, 5)));
        KNIFE.add((IRecipeCore)new KnifeRecipe(new ItemStack((Item)Items.field_151026_S), new ItemStack(Items.field_151116_aA, 4)));
        KNIFE.add((IRecipeCore)new KnifeRecipe(new ItemStack((Item)Items.field_151024_Q), new ItemStack(Items.field_151116_aA, 3)));
        KNIFE.add((IRecipeCore)new KnifeRecipe(new ItemStack(Blocks.field_150440_ba), new ItemStack(Items.field_151127_ba, 9)));
        KNIFE.add((IRecipeCore)new KnifeRecipe(new ItemStack(Items.field_151127_ba), new ItemStack(Items.field_151081_bc, 1), new ItemStack(ModItems.GRASS_FIBER)));
        KNIFE.add((IRecipeCore)new KnifeRecipe(new ItemStack(Blocks.field_150423_aK), new ItemStack(Items.field_151080_bb, 4), new ItemStack(ModItems.GRASS_FIBER, 2)));
        KNIFE.add((IRecipeCore)new KnifeRecipe(new ItemStack(Blocks.field_150395_bd), new ItemStack(ModItems.GRASS_FIBER, 3)));
        KNIFE.add((IRecipeCore)new KnifeRecipe(new ItemStack((Block)Blocks.field_150434_aF), new ItemStack(ModItems.GRASS_FIBER, 2)));
        KNIFE.add((IRecipeCore)new KnifeRecipe(new ItemStack((Block)Blocks.field_150398_cm, 1, Short.MAX_VALUE), new ItemStack(ModItems.GRASS_FIBER, 2)));
        KNIFE.add((IRecipeCore)new KnifeRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, Short.MAX_VALUE), new ItemStack(ModItems.GRASS_FIBER)));
        KNIFE.add((IRecipeCore)new KnifeRecipe(new ItemStack((Block)Blocks.field_150327_N, 1, Short.MAX_VALUE), new ItemStack(ModItems.GRASS_FIBER)));
        for (int i = 0; i < 6; ++i) {
            KNIFE.add((IRecipeCore)new KnifeRecipe(new ItemStack((Block)(i < 4 ? Blocks.field_150362_t : Blocks.field_150361_u), 6, i % 4), new ItemStack(Blocks.field_150345_g, 1, i), new ItemStack(ModItems.GRASS_FIBER, 2)));
        }
        KNIFE.add((IRecipeCore)new KnifeRecipe("treeSapling", 1, new ItemStack(ModItems.GRASS_FIBER, 2), new ItemStack(Items.field_151055_y)));
    }

    public static void postInit() {
        actions.forEach(IRecipeAction::apply);
    }

    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistryModifiable r = (IForgeRegistryModifiable)event.getRegistry();
        for (Stone stone : Stone.values()) {
            if (stone.isDefault() || !stone.isEnabled() || !stone.hasCobblestone()) continue;
            String oreName = (String)Util.CASE_CONVERTER.convert((Object)("ROCK_" + stone.name()));
            ModRecipes.register((IForgeRegistry<IRecipe>)r, (IRecipe)new ShapedOreRecipe(new ResourceLocation("notreepunching", "blocks/cobblestone_" + stone.name().toLowerCase()), BlockCobble.get(stone), new Object[]{"RR", "RR", Character.valueOf('R'), oreName}));
        }
        if (ModConfig.TOOLS.enableTinTools) {
            ModRecipes.registerToolRecipes((IForgeRegistry<IRecipe>)r, Metal.TIN);
        }
        if (ModConfig.TOOLS.enableCopperTools) {
            ModRecipes.registerToolRecipes((IForgeRegistry<IRecipe>)r, Metal.COPPER);
        }
        if (ModConfig.TOOLS.enableBronzeTools) {
            ModRecipes.registerToolRecipes((IForgeRegistry<IRecipe>)r, Metal.BRONZE);
        }
        if (ModConfig.TOOLS.enableSteelTools) {
            ModRecipes.registerToolRecipes((IForgeRegistry<IRecipe>)r, Metal.STEEL);
        }
        if (ModConfig.GENERAL.replaceVanillaRecipes) {
            ModRecipes.remove((IForgeRegistryModifiable<IRecipe>)r, "wooden_pickaxe");
            ModRecipes.remove((IForgeRegistryModifiable<IRecipe>)r, "wooden_shovel");
            ModRecipes.remove((IForgeRegistryModifiable<IRecipe>)r, "wooden_hoe");
            ModRecipes.remove((IForgeRegistryModifiable<IRecipe>)r, "wooden_sword");
            ModRecipes.remove((IForgeRegistryModifiable<IRecipe>)r, "wooden_axe");
            ModRecipes.remove((IForgeRegistryModifiable<IRecipe>)r, "stone_pickaxe");
            ModRecipes.remove((IForgeRegistryModifiable<IRecipe>)r, "stone_shovel");
            ModRecipes.remove((IForgeRegistryModifiable<IRecipe>)r, "stone_hoe");
            ModRecipes.remove((IForgeRegistryModifiable<IRecipe>)r, "stone_sword");
            ModRecipes.remove((IForgeRegistryModifiable<IRecipe>)r, "stone_axe");
            ModRecipes.remove((IForgeRegistryModifiable<IRecipe>)r, "flower_pot");
        }
    }

    public static void addScheduledAction(IRecipeAction action) {
        actions.add(action);
    }

    private static void registerToolRecipes(IForgeRegistry<IRecipe> r, Metal metalType) {
        String metalName = metalType.name().toLowerCase() + "_";
        String ingotName = (String)Util.CASE_CONVERTER.convert((Object)("INGOT_" + metalType.name()));
        ModRecipes.register(r, (IRecipe)new ShapedOreRecipe(new ResourceLocation("notreepunching", metalName + "knife"), new ItemStack(ModItems.getTool(ToolType.KNIFE, metalType)), new Object[]{"I", "S", Character.valueOf('I'), ingotName, Character.valueOf('S'), "stickWood"}));
        ModRecipes.register(r, (IRecipe)new ShapedOreRecipe(new ResourceLocation("notreepunching", metalName + "saw"), new ItemStack(ModItems.getTool(ToolType.SAW, metalType)), new Object[]{"  S", " SI", "SI ", Character.valueOf('I'), ingotName, Character.valueOf('S'), "stickWood"}));
        ModRecipes.register(r, (IRecipe)new ShapedOreRecipe(new ResourceLocation("notreepunching", metalName + "mattock"), new ItemStack(ModItems.getTool(ToolType.MATTOCK, metalType)), new Object[]{"III", " SI", " S ", Character.valueOf('I'), ingotName, Character.valueOf('S'), "stickWood"}));
    }

    private static void register(IForgeRegistry<IRecipe> registry, IRecipe recipe) {
        recipe.setRegistryName(new ResourceLocation(recipe.func_193358_e()));
        registry.register((IForgeRegistryEntry)recipe);
    }

    private static void remove(IForgeRegistryModifiable<IRecipe> registry, String name) {
        registry.remove(new ResourceLocation("minecraft:" + name));
    }
}

